<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
	<title>Billx - POS</title>

	<link rel="preconnect" href="https://fonts.googleapis.com">
	<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
	<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@200;300;400;500;600&display=swap" rel="stylesheet">
	<link href="assets/css/bootstrap.min.css" rel="stylesheet" />
	<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet" />
	<link href="assets/css/style.css" rel="stylesheet" />
	<link href="assets/css/media.css" rel="stylesheet" />

</head>
<body>
	<!-- Header -->
	<header class="main-header bg-white z-1">
		<nav class="navbar navbar-expand-lg bg-transparent border-bottom">
			<div class="container-fluid px-3">
				<a class="navbar-brand m-0" href="#">
					<img class="" alt="Tblillx Logo" src="assets/images/logo.svg" />
				</a>
				<div id="headerFormContainer" class="header-form-container ms-xl-5 ms-lg-3 ms-0">
					<div class="p-lg-0 p-3">
						<form class="header-search-form d-flex position-relative" role="search">
							<input class="form-control m-0 rounded-8 font-size-14" type="search" placeholder="Search Menu..." aria-label="Search Menu">
							<button class="btn btn-default header-serch-qr-btn" type="submit"></button>
						</form>
					</div>
				</div>
				<button type="button" class="btn btn-link p-2 ms-auto border border-dark search-toggle-btn d-flex d-lg-none align-items-center rounded-8" onclick="toggleHeight('headerFormContainer')">
					<svg class="d-block" width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
						<path d="M12.4105 12.4189C13.623 11.2085 14.3731 9.53516 14.3731 7.68657C14.3731 3.99368 11.3795 1 7.68657 1C3.99368 1 1 3.99368 1 7.68657C1 11.3795 3.99368 14.3731 7.68657 14.3731C9.53087 14.3731 11.2008 13.6265 12.4105 12.4189ZM12.4105 12.4189L15 15" stroke="#19191C" stroke-width="1.5" stroke-linecap="round"/>
					</svg>
				</button>
				<button class="navbar-toggler ms-3 border border-dark hover-effect-none rounded-8" type="button" data-bs-toggle="collapse" data-bs-target="#billxPrimaryMenu" aria-controls="billxPrimaryMenu" aria-expanded="false" aria-label="Toggle navigation">
					<span class="navbar-toggler-icon"></span>
				</button>
				<div class="collapse navbar-collapse primary-header-navbar" id="billxPrimaryMenu">
					<ul class="navbar-nav theme-menu header-nav-right ms-auto mb-2 mb-lg-0">
						<li class="nav-item"><a class="nav-link" href="billx-pos.php"><i class="fa-solid fa-home me-2"></i>Home</a></li>
						<li class="nav-item"><a class="nav-link active" aria-current="page" href="customers.php"><i class="fa-solid fa-users me-2"></i>Customers</a></li>
						<li class="nav-item"><a class="nav-link" href="#"><i class="fa-solid fa-clock me-2"></i>Holder</a></li>
						<li class="nav-item"><a class="nav-link" href="#"><i class="fa-solid fa-file-lines me-2"></i>Bills</a></li>
		      		</ul>
				</div>
				<div class="header-time-table ms-1 text-black px-3 py-2 rounded-pill d-none d-lg-flex">
					<small>10:53:00  26/02/2023</small>
				</div>
				<div class="btn-group">
					<button type="button" class="btn btn-link user-avatar-btn dropdown-toggle rounded-pill ms-2" data-bs-toggle="dropdown" data-bs-display="static" aria-expanded="false">
						<img src="assets/images/avatar-small.svg" alt="User Avatar" class="d-block">
					</button>
					<ul class="dropdown-menu dropdown-menu-end rounded-8">
						<li><button class="dropdown-item font-size-14" type="button">Dropdown Item 1</button></li>
						<li><button class="dropdown-item font-size-14" type="button">Dropdown Item 2</button></li>
						<li><button class="dropdown-item font-size-14" type="button">Dropdown Item 3</button></li>
					</ul>
				</div>
			</div>
		</nav>
	</header>
	<!-- ./Header -->
	<!-- Main Wrapper -->
	<div class="main-container pt-top">
		<div class="container-fluid px-3">
			<div class="customer-table-container mt-3">
				<div class="customer-table-header">
					<h3 class="font-weight-600">Customers</h3>
					<div class="d-md-flex align-items-start">
						<form class="customer-table-search search-lefticon-btn me-auto mb-2">
							<button type="button" class="btn btn-link search-btn bg-transparent"></button>
							<input type="search" id="addCustomerSearchInput" class="form-control rounded-8 grey-bg-1 border-lighten-1" name="table-search" placeholder="Search..." />
						</form>
						<div class="d-flex flex-wrap">
							<button type="button" class="btn btn-ei font-size-14 d-flex align-items-center rounded-8 px-3 me-2 mb-2 btn-export-all" style="height: 38.33px">
								<svg class="me-2" width="15" height="14" viewBox="0 0 15 14" fill="none" xmlns="http://www.w3.org/2000/svg">
									<path fill-rule="evenodd" clip-rule="evenodd" d="M11.5695 3.2103L8.07607 0.21624C7.91297 0.0732588 7.70706 0.000108168 7.50007 1.18581e-07C7.35844 -7.34128e-05 7.2163 0.0340499 7.08703 0.103399C7.02942 0.134224 6.97468 0.17187 6.92407 0.21624L3.43061 3.2103C3.06368 3.52477 3.02116 4.07716 3.33563 4.44408C3.65011 4.81101 4.20249 4.85353 4.56942 4.53906L6.62501 2.77732V9.55388C6.62501 10.0371 7.01676 10.4289 7.50001 10.4289C7.98326 10.4289 8.37501 10.0371 8.37501 9.55388L8.37501 2.77723L10.4307 4.53906C10.7976 4.85353 11.35 4.81101 11.6645 4.44408C11.979 4.07716 11.9365 3.52477 11.5695 3.2103ZM2.25 8.75C2.25 8.26675 2.64175 7.875 3.125 7.875H4.4375C4.92075 7.875 5.3125 7.48325 5.3125 7C5.3125 6.51675 4.92075 6.125 4.4375 6.125H3.125C1.67525 6.125 0.5 7.30025 0.5 8.75V11.375C0.5 12.8247 1.67525 14 3.125 14H11.875C13.3247 14 14.5 12.8247 14.5 11.375V8.75C14.5 7.30025 13.3247 6.125 11.875 6.125H10.5625C10.0793 6.125 9.6875 6.51675 9.6875 7C9.6875 7.48325 10.0793 7.875 10.5625 7.875H11.875C12.3582 7.875 12.75 8.26675 12.75 8.75V11.375C12.75 11.8582 12.3582 12.25 11.875 12.25H3.125C2.64175 12.25 2.25 11.8582 2.25 11.375V8.75Z" fill="#0F3659"/>
								</svg>Export all
							</button>
							<button type="button" class="btn btn-ei font-size-14 d-flex align-items-center rounded-8 px-3 me-2 mb-2 btn-export" style="height: 38.33px">
								<svg class="me-2" width="15" height="14" viewBox="0 0 15 14" fill="none" xmlns="http://www.w3.org/2000/svg">
									<path fill-rule="evenodd" clip-rule="evenodd" d="M11.5695 3.2103L8.07607 0.21624C7.91297 0.0732588 7.70706 0.000108168 7.50007 1.18581e-07C7.35844 -7.34128e-05 7.2163 0.0340499 7.08703 0.103399C7.02942 0.134224 6.97468 0.17187 6.92407 0.21624L3.43061 3.2103C3.06368 3.52477 3.02116 4.07716 3.33563 4.44408C3.65011 4.81101 4.20249 4.85353 4.56942 4.53906L6.62501 2.77732V9.55388C6.62501 10.0371 7.01676 10.4289 7.50001 10.4289C7.98326 10.4289 8.37501 10.0371 8.37501 9.55388L8.37501 2.77723L10.4307 4.53906C10.7976 4.85353 11.35 4.81101 11.6645 4.44408C11.979 4.07716 11.9365 3.52477 11.5695 3.2103ZM2.25 8.75C2.25 8.26675 2.64175 7.875 3.125 7.875H4.4375C4.92075 7.875 5.3125 7.48325 5.3125 7C5.3125 6.51675 4.92075 6.125 4.4375 6.125H3.125C1.67525 6.125 0.5 7.30025 0.5 8.75V11.375C0.5 12.8247 1.67525 14 3.125 14H11.875C13.3247 14 14.5 12.8247 14.5 11.375V8.75C14.5 7.30025 13.3247 6.125 11.875 6.125H10.5625C10.0793 6.125 9.6875 6.51675 9.6875 7C9.6875 7.48325 10.0793 7.875 10.5625 7.875H11.875C12.3582 7.875 12.75 8.26675 12.75 8.75V11.375C12.75 11.8582 12.3582 12.25 11.875 12.25H3.125C2.64175 12.25 2.25 11.8582 2.25 11.375V8.75Z" fill="#0F3659"/>
								</svg>Export
							</button>
							<button type="button" class="btn d-flex font-size-14 btn-primary cs-btn-primary align-items-center rounded-8 px-3 mb-2 btn-export open-sidenav openSidebarBtn" data-target="addCustomersSidebar" style="height: 38.33px">
								<svg class="me-2" width="19" height="19" viewBox="0 0 19 19" fill="none" xmlns="http://www.w3.org/2000/svg">
									<path d="M3.7959 9.25148C3.7959 9.03469 3.88202 8.82677 4.03532 8.67347C4.18862 8.52018 4.39653 8.43405 4.61333 8.43405H8.42038V4.627C8.42038 4.41021 8.5065 4.20229 8.6598 4.04899C8.8131 3.89569 9.02102 3.80957 9.23781 3.80957C9.45461 3.80957 9.66253 3.89569 9.81582 4.04899C9.96912 4.20229 10.0552 4.41021 10.0552 4.627V8.43405H13.8623C14.0791 8.43405 14.287 8.52018 14.4403 8.67347C14.5936 8.82677 14.6797 9.03469 14.6797 9.25148C14.6797 9.46828 14.5936 9.6762 14.4403 9.8295C14.287 9.98279 14.0791 10.0689 13.8623 10.0689H10.0552V13.876C10.0552 14.0928 9.96912 14.3007 9.81582 14.454C9.66253 14.6073 9.45461 14.6934 9.23781 14.6934C9.02102 14.6934 8.8131 14.6073 8.6598 14.454C8.5065 14.3007 8.42038 14.0928 8.42038 13.876V10.0689H4.61333C4.39653 10.0689 4.18862 9.98279 4.03532 9.8295C3.88202 9.6762 3.7959 9.46828 3.7959 9.25148Z" fill="white"/>
									<path fill-rule="evenodd" clip-rule="evenodd" d="M4.13393 0.280339C7.52624 -0.095725 10.9497 -0.095725 14.342 0.280339C16.3333 0.502681 17.9409 2.07106 18.1741 4.07322C18.5774 7.51406 18.5774 10.9898 18.1741 14.4306C17.9398 16.4328 16.3322 18.0001 14.342 18.2235C10.9497 18.5996 7.52624 18.5996 4.13393 18.2235C2.14267 18.0001 0.535054 16.4328 0.301814 14.4306C-0.100605 10.9899 -0.100605 7.51396 0.301814 4.07322C0.535054 2.07106 2.14376 0.502681 4.13393 0.280339ZM14.1611 1.9043C10.889 1.54162 7.58692 1.54162 4.31486 1.9043C3.70913 1.9715 3.14375 2.24095 2.71005 2.66911C2.27635 3.09727 1.99966 3.65914 1.92469 4.26396C1.53706 7.57834 1.53706 10.9266 1.92469 14.241C1.99989 14.8456 2.27668 15.4072 2.71036 15.8352C3.14404 16.2631 3.7093 16.5324 4.31486 16.5995C7.55952 16.9614 10.9164 16.9614 14.1611 16.5995C14.7665 16.5322 15.3315 16.2628 15.7649 15.8349C16.1984 15.4069 16.475 14.8454 16.5502 14.241C16.9378 10.9266 16.9378 7.57834 16.5502 4.26396C16.4748 3.6597 16.1981 3.09846 15.7646 2.67075C15.3312 2.24305 14.7663 1.97381 14.1611 1.90648V1.9043Z" fill="white"/>
								</svg>Add Customers
							</button>
						</div>
					</div>
					<div class="customer-table-content mb-3">
						<div class="table-responsive">
							<table id="customerTable" class="table align-middle pd-5 customer-table customer-table-header m-0">
							    <thead>
							        <tr>
							            <th>#</th>
							            <th>Name</th>
							            <th>Company</th>
							            <th>Email</th>
							            <th>Phone Number</th>
							            <th>Customer Group</th>
							            <th>Action</th>
							        </tr>
							    </thead>
							    <tbody>
							    	<?php for ($x = 1; $x <= 6; $x++) { ?>
							        <tr>
							        	<td valign="middle"><?php echo $x ?></td>
							            <td valign="middle">Mohmed Ahmed</td>
							            <td valign="middle">comanyname</td>
							            <td valign="middle">comanyname@mail.com</td>
							            <td valign="middle">+20 123 456 789 <?php echo $x ?></td>
							            <td valign="middle">takeway</td>
							            <td valign="middle">
							            	<div class="d-flex">
												<button type="button" class="btn btn-table-edit font-size-13 d-flex align-items-center rounded-8 py-1 px-2 float-start">
													<svg class="me-1" width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
														<path fill-rule="evenodd" clip-rule="evenodd" d="M15.6543 2.75024C15.7318 2.86784 15.7663 3.00856 15.752 3.14866C15.7378 3.28876 15.6756 3.41964 15.576 3.51921L8.0796 11.0148C8.00291 11.0915 7.90723 11.1463 7.80235 11.1738L4.68 11.9893C4.57678 12.0162 4.46833 12.0157 4.36539 11.9877C4.26245 11.9598 4.16862 11.9054 4.09319 11.8299C4.01777 11.7545 3.96338 11.6607 3.93543 11.5578C3.90748 11.4548 3.90694 11.3464 3.93386 11.2431L4.74931 8.12161C4.77311 8.0279 4.81802 7.94088 4.8806 7.86719L12.4047 0.347928C12.5194 0.233398 12.6749 0.169067 12.8369 0.169067C12.999 0.169067 13.1545 0.233398 13.2691 0.347928L15.576 2.65402C15.6053 2.68338 15.6315 2.71562 15.6543 2.75024ZM14.2786 3.08621L12.8369 1.64531L5.89094 8.59131L5.38128 10.5427L7.33265 10.033L14.2786 3.08621Z" fill="#737791"/>
														<path d="M14.1754 12.3268C14.3983 10.4218 14.4694 8.50221 14.3882 6.586C14.3865 6.54086 14.394 6.49584 14.4104 6.45374C14.4269 6.41165 14.4518 6.3734 14.4836 6.34137L15.286 5.53897C15.308 5.51692 15.3358 5.50167 15.3662 5.49505C15.3966 5.48844 15.4282 5.49073 15.4573 5.50167C15.4864 5.51261 15.5118 5.53172 15.5303 5.55671C15.5488 5.5817 15.5597 5.6115 15.5617 5.64253C15.7127 7.91864 15.6554 10.2038 15.3904 12.4695C15.198 14.1183 13.8737 15.4108 12.2322 15.5943C9.38247 15.9099 6.50663 15.9099 3.65692 15.5943C2.01623 15.4108 0.691127 14.1183 0.498681 12.4695C0.160596 9.57904 0.160596 6.65906 0.498681 3.76863C0.691127 2.11979 2.01542 0.827302 3.65692 0.643826C5.81979 0.403988 7.99896 0.345887 10.1715 0.470135C10.2026 0.472367 10.2324 0.483464 10.2574 0.50211C10.2824 0.520756 10.3015 0.546171 10.3125 0.575345C10.3235 0.604518 10.3259 0.636228 10.3194 0.666719C10.3129 0.69721 10.2978 0.725205 10.2759 0.747388L9.46618 1.55631C9.43446 1.58791 9.39661 1.61268 9.35496 1.62909C9.31331 1.6455 9.26873 1.6532 9.22399 1.65172C7.41105 1.59009 5.59602 1.65959 3.7931 1.85966C3.26627 1.91797 2.77448 2.15218 2.39717 2.52446C2.01987 2.89673 1.77908 3.38533 1.7137 3.91133C1.38675 6.70695 1.38675 9.53115 1.7137 12.3268C1.77908 12.8528 2.01987 13.3414 2.39717 13.7136C2.77448 14.0859 3.26627 14.3201 3.7931 14.3784C6.52893 14.6842 9.36017 14.6842 12.0968 14.3784C12.6236 14.3201 13.1154 14.0859 13.4927 13.7136C13.87 13.3414 14.11 12.8528 14.1754 12.3268Z" fill="#737791"/>
													</svg>Edit
												</button>
												<button type="button" class="btn d-flex align-items-center rounded-8 p-0 ms-3 float-start">
													<svg width="16" height="18" viewBox="0 0 16 18" fill="none" xmlns="http://www.w3.org/2000/svg">
														<path d="M14.1146 5.97228L14.203 5.97349C14.5311 6.00061 14.7826 6.27303 14.8 6.60094L14.7915 6.78377L14.512 10.2071L14.2187 13.5479C14.1567 14.2148 14.1012 14.7773 14.0532 15.2201C13.8866 16.7633 12.8849 17.7176 11.3748 17.7459C9.02166 17.7893 6.75979 17.7889 4.56331 17.7414C3.09687 17.7106 2.10992 16.746 1.94626 15.2264L1.83315 14.1068L1.6355 11.9351L1.43303 9.55206L1.20153 6.69145C1.17275 6.32443 1.43956 6.00298 1.79746 5.97347C2.12554 5.94643 2.41627 6.17408 2.48461 6.49491L2.51121 6.75709L2.72859 9.43886L2.96595 12.2186C3.07241 13.4219 3.16474 14.3957 3.23863 15.0798C3.3319 15.9458 3.78789 16.3915 4.59032 16.4083C6.76965 16.4554 9.01465 16.4559 11.3512 16.4127C12.2024 16.3968 12.6656 15.9555 12.7609 15.0732L12.8735 13.9596C12.9065 13.6165 12.9417 13.2376 12.979 12.826L13.2166 10.0923L13.5028 6.58444C13.5292 6.24802 13.7949 5.99014 14.1146 5.97228ZM0.650125 4.43483C0.291071 4.43483 0 4.13634 0 3.76814C0 3.43062 0.24458 3.15168 0.561907 3.10753L0.650125 3.10145H3.48241C3.81899 3.10145 4.11364 2.87936 4.21904 2.55937L4.24483 2.46056L4.46493 1.33807C4.65877 0.594636 5.28818 0.0653272 6.02577 0.00562799L6.16526 0H9.83457C10.5844 0 11.2465 0.485578 11.5014 1.2359L11.5444 1.37963L11.7549 2.46029C11.8211 2.79886 12.0911 3.05173 12.4178 3.09491L12.5174 3.10145H15.3499C15.7089 3.10145 16 3.39994 16 3.76814C16 4.10566 15.7554 4.3846 15.4381 4.42874L15.3499 4.43483H0.650125ZM9.83457 1.33338H6.16526C5.98285 1.33338 5.8207 1.44287 5.75335 1.58047L5.73051 1.64092L5.51982 2.72212C5.49405 2.85408 5.4567 2.98116 5.40899 3.10232L10.5909 3.1025C10.5612 3.0269 10.5354 2.949 10.514 2.86905L10.48 2.72185L10.2788 1.68249C10.2318 1.50215 10.0865 1.37012 9.9113 1.33993L9.83457 1.33338Z" fill="#FF3A29"/>
													</svg>
												</button>
							            	</div>
							            </td>
							        </tr>
							        <?php } ?>
							    </tbody>
							</table>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
	<!-- ./Main Wrapper -->

	<!-- Sidebar -->
	<aside id="addCustomersSidebar" class="main-sidebar mobile-view with-overlay z-3">
		<div class="save-product-sidebar p-3 h-100">
			<div class="card add-costumer-detail border-0 h-100">
				<div class="card-header bg-transparent border-0 px-0 py-2 mb-2 d-flex align-items-start">
					<h4 class="m-0 font-weight-600 me-auto">Add new customer</h4>
					<button type="button" class="btn btn-link p-0 closeSidebarBtn btn-close ms-sm-auto ms-4">
						<svg class="" width="19" height="20" viewBox="0 0 19 20" fill="none" xmlns="http://www.w3.org/2000/svg">
							<path d="M2 9.93811H16.9771" stroke="#19191C" stroke-width="3" stroke-linecap="round"/>
							<path d="M9.48877 2V17.8742" stroke="#19191C" stroke-width="3" stroke-linecap="round"/>
						</svg>
					</button>
				</div>
				<div class="sidenav-content d-flex flex-column h-100">
					<form class="d-flex flex-column h-100">
						<div class="mb-2">
							<label class="form-label mb-0 font-size-13 dark-text-2" for="addCustomerFirstName">Frist name <span>*</span></label>
							<input type="text" class="form-control rounded-8 font-size-13 py-2 grey-text-3 border-lighten-2" id="addCustomerFirstName" placeholder="Mohamed">
						</div>
						<div class="mb-2">
							<label class="form-label mb-0 font-size-13 dark-text-2" for="addCustomerLastName">Last name <span>*</span></label>
							<input type="text" class="form-control rounded-8 font-size-13 py-2 grey-text-3 border-lighten-2" id="addCustomerLastName" placeholder="Ahmed">
						</div>
						<div class="mb-2">
							<label class="form-label mb-0 font-size-13 dark-text-2" for="addCustomerPhoneNumber">Phone Number <span>*</span></label>
							<input type="text" class="form-control rounded-8 font-size-13 py-2 grey-text-3 border-lighten-2" id="addCustomerPhoneNumber" placeholder="+20 123 456 789">
						</div>
						<div class="mb-2">
							<label class="form-label mb-0 font-size-13 dark-text-2" for="addCustomerEmail">Email <span>*</span></label>
							<input type="text" class="form-control rounded-8 font-size-13 py-2 grey-text-3 border-lighten-2" id="addCustomerEmail" placeholder="ahmed@email.com">
						</div>
						<div class="mb-2">
							<label class="form-label mb-0 font-size-13 dark-text-2" for="addCustomerCompany">Company <span>*</span></label>
							<input type="text" class="form-control rounded-8 font-size-13 py-2 grey-text-3 border-lighten-2" id="addCustomerCompany" placeholder="Mohmed">
						</div>
						<div class="mb-2">
							<label class="form-label mb-0 font-size-13 dark-text-2" for="addCustomerGroup">Customer Group <span>*</span></label>
							<select id="addCustomerGroup" class="form-select rounded-8 font-size-13 py-2 grey-text-3 border-lighten-2">
								<option selected>Takeway</option>
								<?php for ($x = 1; $x <= 5; $x++) { ?>
								<option>Takeway <?php echo $x; ?></option>
								<?php } ?>
							</select>
						</div>
						<button type="button" id="addCustomerSubmitBtn" class="btn btn-primary cs-btn-primary rounded-8 p-0 py-3 w-100 font-weight-600 closeSidebarBtn mt-auto">Add customer</button>
					</form>

				</div>
			</div>
		</div>
	</aside>

	<!-- ./Sidebar -->
	
	<div id="overlay" class="overlay z-2 closeSidebarBtn"></div>

	<script src="assets/js/jquery.min.js"></script>
	<script src="assets/js/bootstrap.bundle.min.js"></script>
	<script type="text/javascript">

		$(document).ready(function () {

			$(".save-product-btn").click(function(){
				$(".tblillx-right-sidebar").addClass("d-flex col-lg open");
			});

			$("#chargePaymentBtn").click(function(){
				$(".tblillx-right-sidebar").removeClass("d-flex col-lg open");
			});

			function openSidebar(sidebarId) {
			    // $("#" + sidebarId).css("transform", "translateX(0px)");
			    $("#" + sidebarId).addClass("open");
			    $("#overlay").fadeIn(150);
			    $("body").addClass("overflow-hidden");
			    console.log(sidebarId);
			}
			
			$(".openSidebarBtn").click(function () {
			    var targetSidebar = $(this).data("target");
			    openSidebar(targetSidebar);
			});

			$(".closeSidebarBtn").click(function () {
				var targetSidebar1 = $(".main-sidebar.open").attr("id");
			    // $("#"+targetSidebar1+".open").css("transform", "translateX(450px)");
			    $("#"+targetSidebar1+".open").removeClass("open");
			    $("body").removeClass("overflow-hidden");
			    $("#overlay").fadeOut(150);
			});

		});

		function toggleHeight(headerFormContainer) {
			var headerFormContainer = document.getElementById(headerFormContainer);
			if (headerFormContainer.style.height === "0px" || headerFormContainer.style.height === "") {
				headerFormContainer.style.height = headerFormContainer.scrollHeight + "px";
			} else {
				headerFormContainer.style.height = "0px";
			}
		}
	</script>
</body>
</html>