<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
	<title>Billx - POS</title>

	<link rel="preconnect" href="https://fonts.googleapis.com">
	<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
	<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@200;300;400;500;600&display=swap" rel="stylesheet">
	<link href="assets/css/bootstrap.min.css" rel="stylesheet" />
	<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet" />
	<link href="assets/css/style.css" rel="stylesheet" />
	<link href="assets/css/media.css" rel="stylesheet" />

</head>
<body>
	<!-- Header -->
	<header class="main-header bg-white z-1">
		<nav class="navbar navbar-expand-lg bg-transparent border-bottom">
			<div class="container-fluid px-3">
				<a class="navbar-brand m-0" href="#">
					<img class="" alt="Tblillx Logo" src="assets/images/logo.svg" />
				</a>
				<div id="headerFormContainer" class="header-form-container ms-xl-5 ms-lg-3 ms-0">
					<div class="p-lg-0 p-3">
						<form class="header-search-form d-flex position-relative" role="search">
							<input class="form-control m-0 rounded-8 font-size-14" type="search" placeholder="Search Menu..." aria-label="Search Menu">
							<button class="btn btn-default header-serch-qr-btn" type="submit"></button>
						</form>
					</div>
				</div>
				<button type="button" class="btn btn-link p-2 ms-auto border border-dark search-toggle-btn d-flex d-lg-none align-items-center rounded-8" onclick="toggleHeight('headerFormContainer')">
					<svg class="d-block" width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
						<path d="M12.4105 12.4189C13.623 11.2085 14.3731 9.53516 14.3731 7.68657C14.3731 3.99368 11.3795 1 7.68657 1C3.99368 1 1 3.99368 1 7.68657C1 11.3795 3.99368 14.3731 7.68657 14.3731C9.53087 14.3731 11.2008 13.6265 12.4105 12.4189ZM12.4105 12.4189L15 15" stroke="#19191C" stroke-width="1.5" stroke-linecap="round"/>
					</svg>
				</button>
				<button class="navbar-toggler ms-3 border border-dark hover-effect-none rounded-8" type="button" data-bs-toggle="collapse" data-bs-target="#billxPrimaryMenu" aria-controls="billxPrimaryMenu" aria-expanded="false" aria-label="Toggle navigation">
					<span class="navbar-toggler-icon"></span>
				</button>
				<div class="collapse navbar-collapse primary-header-navbar" id="billxPrimaryMenu">
					<ul class="navbar-nav theme-menu header-nav-right ms-auto mb-2 mb-lg-0">
						<li class="nav-item"><a class="nav-link active" aria-current="page" href="billx-pos.php"><i class="fa-solid fa-home me-2"></i>Home</a></li>
						<li class="nav-item"><a class="nav-link" href="customers.php"><i class="fa-solid fa-users me-2"></i>Customers</a></li>
						<li class="nav-item"><a class="nav-link" href="#"><i class="fa-solid fa-clock me-2"></i>Holder</a></li>
						<li class="nav-item"><a class="nav-link" href="#"><i class="fa-solid fa-file-lines me-2"></i>Bills</a></li>
		      		</ul>
				</div>
				<div class="header-time-table ms-1 text-black px-3 py-2 rounded-pill d-none d-lg-flex">
					<small>10:53:00  26/02/2023</small>
				</div>
				<div class="btn-group">
					<button type="button" class="btn btn-link user-avatar-btn dropdown-toggle rounded-pill ms-2" data-bs-toggle="dropdown" data-bs-display="static" aria-expanded="false">
						<img src="assets/images/avatar-small.svg" alt="User Avatar" class="d-block">
					</button>
					<ul class="dropdown-menu dropdown-menu-end rounded-8">
						<li><button class="dropdown-item font-size-14" type="button">Dropdown Item 1</button></li>
						<li><button class="dropdown-item font-size-14" type="button">Dropdown Item 2</button></li>
						<li><button class="dropdown-item font-size-14" type="button">Dropdown Item 3</button></li>
					</ul>
				</div>
			</div>
		</nav>
	</header>
	<!-- ./Header -->
	<!-- Main Wrapper -->
	<div class="main-container pt-top">
		<div class="container-fluid px-3 border-bottom bg-white">
			<div class="secondary-topbar-menu">
				<ul class="nav">
					<li class="nav-item"><a class="nav-link active" aria-current="page" href="#">All products</a></li>
					<li class="nav-item"><a class="nav-link" href="#">Coffee</a></li>
					<li class="nav-item"><a class="nav-link" href="#">Drinks</a></li>
					<li class="nav-item"><a class="nav-link" href="#">Milk</a></li>
					<li class="nav-item"><a class="nav-link" href="#">Water</a></li>
					<li class="nav-item"><a class="nav-link" href="#">Candy</a></li>
				</ul>
			</div>
		</div>
		<div class="container-fluid">
			<div class="row">
				<div class="col-lg p-3">
					<div class="row g-3 row-cols-2 row-cols-sm-3 row-cols-md-4 row-cols-lg-4 row-cols-xl-5">
					<?php for ($x = 1; $x <= 4; $x++) { ?>
						<div class="col tbillx-product-column">
							<div class="card rounded-16 p-0">
								<div class="card-body p-3">
									<a href="#" class="link text-center d-block open-sidenav openSidebarBtn" data-target="saveProductSidebar">
										<img class="products-thumb-image" src="assets/images/product-1.png" alt="Dish wash cleaner">
									</a>
								</div>
								<div class="card-footer border-0 bg-transparent pb-2 pt-0">
									<div class="products-title">
										<a href="#" class="link text-decoration-none d-block open-sidenav openSidebarBtn" data-target="saveProductSidebar">
											<h5 class="dark-text-1 title d-block">Dish wash cleaner</h5>
										</a>
									</div>
									<div class="d-flex justify-content-between">
										<div class="products-price-detail">
											<span class="d-block grey-text-1 line-height-14">Price</span>
											<span class="products-price red-text-1 font-size-20 font-weight-600">$ 25.0</span>
										</div>
										<a href="#" role="button" class="btn btn-link products-price p-0 mt-auto open-sidenav openSidebarBtn" data-target="saveProductSidebar">
											<svg width="34" height="34" viewBox="0 0 34 34" fill="none" xmlns="http://www.w3.org/2000/svg">
												<circle cx="17" cy="17" r="17" fill="#E4E4E4"/>
												<path d="M10 17H24M17 10V24" stroke="#0066CC" stroke-width="1.5" stroke-linecap="round"/>
											</svg>
										</a>
									</div>
								</div>
							</div>
						</div>
						<div class="col tbillx-product-column">
							<div class="card rounded-16 p-0">
								<div class="card-body p-3">
									<a href="#" class="link text-center d-block open-sidenav openSidebarBtn" data-target="saveProductSidebar">
										<img class="products-thumb-image" src="assets/images/product-2.png" alt="Dish wash cleaner">
									</a>
								</div>
								<div class="card-footer border-0 bg-transparent pb-2 pt-0">
									<div class="products-title">
										<a href="#" class="link text-decoration-none d-block open-sidenav openSidebarBtn" data-target="saveProductSidebar">
											<h5 class="dark-text-1 title d-block">Black Tea 100</h5>
										</a>
									</div>
									<div class="d-flex justify-content-between">
										<div class="products-price-detail">
											<span class="d-block grey-text-1 line-height-14">Price</span>
											<span class="products-price red-text-1 font-size-20 font-weight-600">$ 12.0</span>
										</div>
										<a href="#" role="button" class="btn btn-link products-price p-0 mt-auto open-sidenav openSidebarBtn" data-target="saveProductSidebar">
											<svg width="34" height="34" viewBox="0 0 34 34" fill="none" xmlns="http://www.w3.org/2000/svg">
												<circle cx="17" cy="17" r="17" fill="#E4E4E4"/>
												<path d="M10 17H24M17 10V24" stroke="#0066CC" stroke-width="1.5" stroke-linecap="round"/>
											</svg>
										</a>
									</div>
								</div>
							</div>
						</div>
						<div class="col tbillx-product-column">
							<div class="card rounded-16 p-0">
								<div class="card-body p-3">
									<a href="#" class="link text-center d-block open-sidenav openSidebarBtn" data-target="saveProductSidebar">
										<img class="products-thumb-image" src="assets/images/product-3.png" alt="Dish wash cleaner">
									</a>
								</div>
								<div class="card-footer border-0 bg-transparent pb-2 pt-0">
									<div class="products-title">
										<a href="#" class="link text-decoration-none d-block open-sidenav openSidebarBtn" data-target="saveProductSidebar">
											<h5 class="dark-text-1 title d-block">Automatic Powder</h5>
										</a>
									</div>
									<div class="d-flex justify-content-between">
										<div class="products-price-detail">
											<span class="d-block grey-text-1 line-height-14">Price</span>
											<span class="products-price red-text-1 font-size-20 font-weight-600">$ 12.0</span>
										</div>
										<a href="#" role="button" class="btn btn-link products-price p-0 mt-auto open-sidenav openSidebarBtn" data-target="saveProductSidebar">
											<svg width="34" height="34" viewBox="0 0 34 34" fill="none" xmlns="http://www.w3.org/2000/svg">
												<circle cx="17" cy="17" r="17" fill="#E4E4E4"/>
												<path d="M10 17H24M17 10V24" stroke="#0066CC" stroke-width="1.5" stroke-linecap="round"/>
											</svg>
										</a>
									</div>
								</div>
							</div>
						</div>
						<div class="col tbillx-product-column">
							<div class="card rounded-16 p-0">
								<div class="card-body p-3">
									<a href="#" class="link text-center d-block open-sidenav openSidebarBtn" data-target="saveProductSidebar">
										<img class="products-thumb-image" src="assets/images/product-4.png" alt="Dish wash cleaner">
									</a>
								</div>
								<div class="card-footer border-0 bg-transparent pb-2 pt-0">
									<div class="products-title">
										<a href="#" class="link text-decoration-none d-block open-sidenav openSidebarBtn" data-target="saveProductSidebar">
											<h5 class="dark-text-1 title d-block">Fine Flour</h5>
										</a>
									</div>
									<div class="d-flex justify-content-between">
										<div class="products-price-detail">
											<span class="d-block grey-text-1 line-height-14">Price</span>
											<span class="products-price red-text-1 font-size-20 font-weight-600">$ 25.0</span>
										</div>
										<a href="#" role="button" class="btn btn-link products-price p-0 mt-auto open-sidenav openSidebarBtn" data-target="saveProductSidebar">
											<svg width="34" height="34" viewBox="0 0 34 34" fill="none" xmlns="http://www.w3.org/2000/svg">
												<circle cx="17" cy="17" r="17" fill="#E4E4E4"/>
												<path d="M10 17H24M17 10V24" stroke="#0066CC" stroke-width="1.5" stroke-linecap="round"/>
											</svg>
										</a>
									</div>
								</div>
							</div>
						</div>
						<div class="col tbillx-product-column">
							<div class="card rounded-16 p-0">
								<div class="card-body p-3">
									<a href="#" class="link text-center d-block open-sidenav openSidebarBtn" data-target="saveProductSidebar">
										<img class="products-thumb-image" src="assets/images/product-5.png" alt="Dish wash cleaner">
									</a>
								</div>
								<div class="card-footer border-0 bg-transparent pb-2 pt-0">
									<div class="products-title">
										<a href="#" class="link text-decoration-none d-block open-sidenav openSidebarBtn" data-target="saveProductSidebar">
											<h5 class="dark-text-1 title d-block">Tomato Paste</h5>
										</a>
									</div>
									<div class="d-flex justify-content-between">
										<div class="products-price-detail">
											<span class="d-block grey-text-1 line-height-14">Price</span>
											<span class="products-price red-text-1 font-size-20 font-weight-600">$ 25.0</span>
										</div>
										<a href="#" role="button" class="btn btn-link products-price p-0 mt-auto open-sidenav openSidebarBtn" data-target="saveProductSidebar">
											<svg width="34" height="34" viewBox="0 0 34 34" fill="none" xmlns="http://www.w3.org/2000/svg">
												<circle cx="17" cy="17" r="17" fill="#E4E4E4"/>
												<path d="M10 17H24M17 10V24" stroke="#0066CC" stroke-width="1.5" stroke-linecap="round"/>
											</svg>
										</a>
									</div>
								</div>
							</div>
						</div>
					<?php } ?>
					</div>
				</div>
				<div class="flex-column bg-white border-start px-0 tblillx-right-sidebar overflow-hidden">
					<div class="products-active-count d-flex px-3 py-1 border-bottom">
						<span class="products-active-status me-auto">Active</span>
						<span id="checkedCount" class="products-active-counts"></span>
					</div>
					<div class="product-list-sidebar p-3 pt-2 mb-auto">
						<table class="table product-list-table">
							<tbody>
								<?php for ($x = 1; $x <= 5; $x++) { ?>
								<tr>
									<td width="20" valign="middle">
										<div class="form-check custom-form-check p-0">
											<input class="form-check-input me-0 ms-0" type="checkbox" value="" id="tbillxProductCheck<?php echo $x ?>" >
											<label class="form-check-label m-0" for="tbillxProductCheck<?php echo $x ?>"></label>
										</div>
									</td>
									<td width="70">
										<div class="product-td-thumb p-2 border rounded-8 d-flex align-items-center justify-content-center">
											<img class="mh-100" src="assets/images/product-<?php echo $x ?>.png" alt="Dish wash cleaner">
										</div>
									</td>
									<td>
										<strong class="m-0 font-weight-500 d-block mb-1">Dish wash cleaner <?php echo $x ?></strong>
										<span class="d-block line-height-normal sidebar-product-price line-height-18">$ 25.0</span>
										<span class="d-block line-height-normal sidebar-product-qty line-height-18">x2</span>
									</td>
									<td>
										<div class="sidebar-product-totalprice text-end">$ 200.0</div>
									</td>
								</tr>
								<?php } ?>
							</tbody>
						</table>
					</div>
					<div class="product-sidebar-footer overflow-hidden border-top align-self-end w-100">
						<div class="sidebar-footer-btns d-flex px-3 py-2">
							<button type="button" class="btn btn-link border d-flex justify-content-center align-items-center tbillx-cart-btns flex-fill mx-1 bg-white py-2">
								<img src="assets/images/plus-green.svg" alt="Plus Green" class="d-block" />
							</button>
							<button type="button" class="btn btn-link border d-flex justify-content-center align-items-center tbillx-cart-btns flex-fill mx-1 bg-white py-2">
								<img src="assets/images/trash-red.svg" alt="Trash" class="d-block" />
							</button>
							<button type="button" class="btn btn-link border d-flex justify-content-center align-items-center tbillx-cart-btns flex-fill mx-1 bg-white py-2">
								<img src="assets/images/save-btn.svg" alt="Save" class="d-block" />
							</button>
							<button type="button" class="btn btn-link border d-flex justify-content-center align-items-center tbillx-cart-btns flex-fill mx-1 bg-white py-2">
								<img src="assets/images/discount.svg" alt="Discount" class="d-block" />
							</button>
						</div>
						<div class="tbillx-coupon d-flex px-3 mb-3">
							<input type="text" class="form-control bg-white rounded-8 me-2 coupon-code-input" value="Coupon code" name="Coupon Text" readonly="" disabled="" />
							<button type="button" class="btn btn-primary p-0 rounded-8 coupon-btn-checks p-0 w-100"></button>
						</div>
						<div class="tbillx-billing px-3 mb-3">
							<div class="d-flex mb-1">
								<span class="sub-total-text">Sub total</span>
								<span class="sub-total-price ms-auto">$ 50.0</span>
							</div>
							<div class="d-flex mb-1">
								<span class="invoice-tax-text">Tax</span>
								<span class="invoice-tax-price ms-auto">$ 10.0</span>
							</div>
							<div class="d-flex mb-1">
								<span class="invoice-discount-text">Discount</span>
								<span class="invoice-discount-price ms-auto">- $ 20.0</span>
							</div>
						</div>
						<div class="tbillx-billing-btn px-3 pb-3">
							<!-- <div class="bg-primary p-0 rounded-8 d-flex align-items-center overflow-hidden">
								<span class="font-weight-500 font-size-20 text-white px-3">Total</span>
								<span class="font-weight-500 font-size-24 text-white mx-auto">$ 40.0</span>
								<button type="button" class="btn btn-link p-0 rounded-0 text-white btn-cart-proceed m-0 px-3"></button>
							</div> -->
							<button type="button" class="btn btn-primary rounded-12 d-flex p-0 py-3 w-100 justify-content-between openSidebarBtn" data-target="productCartSummery">
								<span class="font-weight-500 font-size-20 text-white px-3">Total</span>
								<span class="font-weight-500 font-size-20 text-white px-3">$ 40.0</span>
								<span class="btn-cart-proceed h-auto"></span>
							</button>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
	<!-- ./Main Wrapper -->

	<!-- Sidebar -->
	<aside id="saveProductSidebar" class="main-sidebar mobile-view with-overlay z-3">
		<div class="save-product-sidebar p-3 h-100">
			<div class="card save-product-detail border-0 h-lg-100">
				<div class="save-product-img border rounded-8 p-3 d-block text-center">
					<img class="w-auto" src="assets/images/product-1.png" alt="Dish wash cleaner">
				</div>
				<div class="save-product-content d-flex flex-column h-100">
					<h5 class="font-size-20 font-weight-600 my-2">Dish wash cleaner</h5>
					<div class="d-flex align-items-center justify-content-between border-bottom pb-3 mb-2">
						<span class="save-product-price red-text-1 font-weight-600 font-size-18">$ 25.0</span>
						<div class="d-flex">
							<button class="btn btn-link value-counter-minus font-size-30 line-height-38 lightblue-bg-1 text-decoration-none rounded-pill p-0" id="minusBtn">-</button>
							<input type="text" id="countInput" class="form-control value-counter-input line-height-12 border-0 rounded-0 text-center px-2 font-size-24 py-0 font-weight-600" value="1">
							<button class="btn btn-link value-counter-plus font-size-30 line-height-38 lightblue-bg-1 text-decoration-none rounded-pill p-0" id="plusBtn">+</button>
						</div>
					</div>
					<div class="save-product-sizes mb-3">
						<h5 class="font-size-20 font-weight-500 m-0 mb-2 grey-text-2">Size</h5>
						<?php for ($x = 1; $x <= 4; $x++) { ?>
						<div class="d-flex mb-2">
							<div class="form-check custom-form-radio position-right m-0 p-0 position-relative flex-fill w-100">
								<label class="form-check-label cursor-pointer px-2 py-2 w-100 rounded-8 border shadow" for="qtyRadioBtn<?php echo $x ?>"><?php echo $x ?> Kg</label>
								<input class="form-check-input" type="radio" name="exampleRadios" id="qtyRadioBtn<?php echo $x ?>" value="option1" checked>
							</div>
							<div class="px-2 flex-fill w-75">
								<input type="text" name="priceField" class="form-control text-center grey-text-2 bg-light" value="$ 10.0" disabled="" />
							</div>
							<div class="flex-fill w-auto d-flex align-items-center">
								<button class="btn btn-link btn-sm counter-button value-counter-minus font-size-28 line-height-34 lightblue-bg-1 text-decoration-none rounded-pill p-0" id="minusBtnSmall">-</button>
								<input type="text" class="form-control input-sm counter-input value-counter-input line-height-12 border-0 rounded-0 text-center px-2 font-size-20 py-0 font-weight-600" id="countInputSmall" value="<?php echo $x ?>">
								<button class="btn btn-link btn-sm counter-button value-counter-plus font-size-28 line-height-34 lightblue-bg-1 text-decoration-none rounded-pill p-0" id="plusBtnSmall">+</button>
							</div>
						</div>
						<?php } ?>
					</div>
					<div class="save-product-note mb-3">
						<textarea class="form-control font-size-14 rounded-8 bg-light grey-text-2" placeholder="Order Note.." rows="3"></textarea>
					</div>
					<button type="button" class="btn btn-primary btn-lg save-product-btn with-vertical-gradient border-0 mt-auto w-100 rounded-8 text-center font-size-20 font-weight-600 text-white mb-3 py-3 closeSidebarBtn">Save</button>
				</div>
			</div>
		</div>
	</aside>

	<aside id="productCartSummery" class="main-sidebar mobile-view mobile-view-on-lg with-overlay z-3 product-cartsummery-sidenav">
		<div class="p-0 h-100 d-lg-flex">
			<div class="card save-product-detail border-0 h-lg-100 w-100 p-3 rounded-0">
				<div class="card-header bg-transparent border-0 p-0 mb-2 d-flex align-items-center">
					<button type="button" class="btn btn-link back-btn bg-light rounded-8 p-0 d-flex align-items-center justify-content-center lightgrey-bg-1">
						<svg class="d-block" width="18" height="12" viewBox="0 0 18 12" fill="none" xmlns="http://www.w3.org/2000/svg">
							<path d="M5.5 10.5L1 6M1 6L5.5 1.5M1 6L17 6" stroke="#0066CC" stroke-width="1.8" stroke-linecap="round" stroke-linejoin="round"/>
						</svg>
					</button>
					<span class="font-size-18 ms-3 font-weight-500">Summery</span>
				</div>
				<div class="card-body p-0">
					<form class="header-search-form d-flex position-relative mb-2" role="search">
						<input class="form-control m-0 rounded-8 font-size-14 mw-inherit py-2" type="search" placeholder="Search customers" aria-label="Search customers">
						<button class="btn btn-default inputbtn-position inputbtn-position-right blue-text-1" type="submit">Add</button>
					</form>
					<div class="product-filter mb-2">
						<div class="product-filter-btn">
							<input type="radio" class="btn-check" name="btnradio" id="preOrderRadioBtn" autocomplete="off" checked>
  							<label class="btn btn-outline-primary font-size-14" for="preOrderRadioBtn">Pre-order</label>
  							<input type="radio" class="btn-check" name="btnradio" id="tableRadioBtn" autocomplete="off">
  							<label class="btn btn-outline-primary font-size-14" for="tableRadioBtn">Table</label>
  							<input type="radio" class="btn-check" name="btnradio" id="deliveryRadioBtn" autocomplete="off">
  							<label class="btn btn-outline-primary font-size-14" for="deliveryRadioBtn">Delivery</label>
						</div>
					</div>
					<div class="product-filter-count overflow-hidden pb-1 border-bottom">
						<span class="float-start">Products</span>
						<span class="float-end">4</span>
					</div>
					<div class="product-list-sidebar mb-auto">
						<table class="table product-list-table">
							<tbody>
								<?php for ($x = 1; $x <= 4; $x++) { ?>
								<tr>
									<td width="70">
										<div class="product-td-thumb p-2 border rounded-8 d-flex align-items-center justify-content-center">
											<img class="mh-100" src="assets/images/product-<?php echo $x ?>.png" alt="Dish wash cleaner">
										</div>
									</td>
									<td>
										<strong class="m-0 font-weight-500 d-block mb-1">Dish wash cleaner <?php echo $x ?></strong>
										<span class="d-block line-height-normal sidebar-product-price line-height-18">$ 25.0</span>
										<span class="d-block line-height-normal sidebar-product-qty line-height-18">x2</span>
									</td>
									<td>
										<div class="sidebar-product-totalprice text-end">$ 200.0</div>
									</td>
								</tr>
								<?php } ?>
							</tbody>
						</table>
					</div>
					<div class="tbillx-billing mb-3">
						<div class="d-flex mb-1">
							<span class="sub-total-text font-size-14">Sub total</span>
							<span class="sub-total-price font-size-14 ms-auto">$ 50.0</span>
						</div>
						<div class="d-flex mb-1">
							<span class="invoice-tax-text font-size-14">Tax</span>
							<span class="invoice-tax-price font-size-14 ms-auto">$ 10.0</span>
						</div>
						<div class="d-flex mb-1">
							<span class="invoice-discount-text font-size-14">Discount</span>
							<span class="invoice-discount-price font-size-14 ms-auto">- $ 20.0</span>
						</div>
					</div>
				</div>
			</div>
			<div class="card save-product-detail border-0 h-lg-100 w-100 p-0 rounded-0 border-start">
				<div class="card-header bg-transparent p-0 p-3 mb-2">
					<h5 class="red-text-1 font-size-36 font-weight-600 mb-1 text-center">$ 140,0</h5>
					<small class="grey-text-4 text-center d-block mb-4">Total amount due</small>
					<div class="form-group">
						<label for="cashReceived" class="form-label mb-0 small">Cash received</label>
						<input type="text" class="form-control rounded-8 bg-light grey-text-2" name="cashReceived" id="cashReceived" placeholder="140.0" value="140.0">
					</div>
				</div>
				<div class="card-body p-3">
					<label class="d-inline-block text-black mb-2">Choose payment method</label>
					<div class="row g-3 row-cols-2 row-cols-sm-3 row-cols-md-3 row-cols-lg-3 row-cols-xl-3 mb-4">
						<div class="col">
							<input type="radio" class="btn-check" name="btnradio" id="cashRadio" autocomplete="off" checked>
							<label class="payment-method-btn btn btn-outline-primary d-flex align-items-center justify-content-center rounded-12" for="cashRadio">
								<img src="assets/images/cash.png" alt="Cash" class="d-block" />
							</label>
						</div>
						<div class="col">
							<input type="radio" class="btn-check" name="btnradio" id="mastercardRadio" autocomplete="off" checked>
							<label class="payment-method-btn btn btn-outline-primary d-flex align-items-center justify-content-center rounded-12" for="mastercardRadio">
								<img src="assets/images/mastercard.png" alt="mastercard" class="d-block" />
							</label>
						</div>
						<div class="col">
							<input type="radio" class="btn-check" name="btnradio" id="visacardRadio" autocomplete="off" checked>
							<label class="payment-method-btn btn btn-outline-primary d-flex align-items-center justify-content-center rounded-12" for="visacardRadio">
								<img src="assets/images/visa.png" alt="Visacard" class="d-block" />
							</label>
						</div>
						<div class="col">
							<input type="radio" class="btn-check" name="btnradio" id="visacardRadio1" autocomplete="off" checked>
							<label class="payment-method-btn btn btn-outline-primary d-flex align-items-center justify-content-center rounded-12" for="visacardRadio1">
								<img src="assets/images/visa.png" alt="Visacard" class="d-block" />
							</label>
						</div>
						<div class="col">
							<input type="radio" class="btn-check" name="btnradio" id="visacardRadio2" autocomplete="off" checked>
							<label class="payment-method-btn btn btn-outline-primary d-flex align-items-center justify-content-center rounded-12" for="visacardRadio2">
								<img src="assets/images/visa.png" alt="Visacard" class="d-block" />
							</label>
						</div>
						<div class="col">
							<input type="radio" class="btn-check" name="btnradio" id="visacardRadio" autocomplete="off" checked>
							<label class="payment-method-btn btn btn-outline-primary d-flex align-items-center justify-content-center rounded-12" for="visacardRadio">
								<img src="assets/images/giftcard.png" alt="giftcard" class="d-block" />
							</label>
						</div>
					</div>
					<button type="button" id="chargePaymentBtn" class="btn btn-primary rounded-12 p-0 py-3 w-100 font-weight-600  closeSidebarBtn">Charge</button>
				</div>
			</div>
		</div>
	</aside>
	<!-- ./Sidebar -->
	
	<div id="overlay" class="overlay z-2 closeSidebarBtn"></div>

	<script src="assets/js/jquery.min.js"></script>
	<script src="assets/js/bootstrap.bundle.min.js"></script>
	<script type="text/javascript">
		var mw = $(window).width();
		if (mw <= 992) {
		}

		$(document).ready(function () {

			$(".save-product-btn").click(function(){
				$(".tblillx-right-sidebar").addClass("d-flex col open");
			});

			$("#chargePaymentBtn").click(function(){
				$(".tblillx-right-sidebar").removeClass("d-flex col open");
			});

			function openSidebar(sidebarId) {
			    // $("#" + sidebarId).css("transform", "translateX(0px)");
			    $("#" + sidebarId).addClass("open");
			    $("#overlay").fadeIn(150);
			    $("body").addClass("overflow-hidden");
			    console.log(sidebarId);
			}
			
			$(".openSidebarBtn").click(function () {
			    var targetSidebar = $(this).data("target");
			    openSidebar(targetSidebar);
			});

			$(".closeSidebarBtn").click(function () {
				var targetSidebar1 = $(".main-sidebar.open").attr("id");
			    // $("#"+targetSidebar1+".open").css("transform", "translateX(450px)");
			    $("#"+targetSidebar1+".open").removeClass("open");
			    $("body").removeClass("overflow-hidden");
			    $("#overlay").fadeOut(150);
			});


			var checkedCount = $('.product-list-sidebar .form-check-input:checked').length;
			if(checkedCount){
				$('#checkedCount').text(checkedCount);
			} else {
				$('#checkedCount').text("");
			}
			$('.product-list-sidebar .form-check-input').on('change', function () {
				var checkedCount = $('.product-list-sidebar .form-check-input:checked').length;
				if(checkedCount){
					$('#checkedCount').text(checkedCount);
				} else {
					$('#checkedCount').text("");
				}
			});

			$("#plusBtn").click(function () {
			    incrementCounter();
			});
			$("#minusBtn").click(function () {
			    decrementCounter();
			});
			$("#countInput").change(function () {
			    var inputVal = parseInt($(this).val()) || 0;
			    setCounterValue(inputVal);
			});
			function incrementCounter() {
			    var count = getCounterValue();
			    setCounterValue(count + 1);
			}
			function decrementCounter() {
			    var count = getCounterValue();
			    if (count > 0) {
			        setCounterValue(count - 1);
			    }
			}
			function getCounterValue() {
			    return parseInt($("#countInput").val()) || 0;
			}
			function setCounterValue(value) {
			    $("#countInput").val(value);
			    $("#counter").text(value);
			}

			// Small btns
			$("#plusBtnSmall").click(function () {
			    incrementCounterSmall();
			});
			$("#minusBtnSmall").click(function () {
			    decrementCounterSmall();
			});
			$("#countInputSmall").change(function () {
			    var inputVal = parseInt($(this).val()) || 0;
			    setCounterValueSmall(inputVal);
			});
			function incrementCounterSmall() {
			    var count = getCounterValueSmall();
			    setCounterValueSmall(count + 1);
			}
			function decrementCounterSmall() {
			    var count = getCounterValueSmall();
			    if (count > 0) {
			        setCounterValueSmall(count - 1);
			    }
			}
			function getCounterValueSmall() {
			    return parseInt($("#countInputSmall").val()) || 0;
			}
			function setCounterValueSmall(value) {
			    $("#countInputSmall").val(value);
			    $("#counterSmall").text(value);
			}

		});

		function toggleHeight(headerFormContainer) {
			var headerFormContainer = document.getElementById(headerFormContainer);
			if (headerFormContainer.style.height === "0px" || headerFormContainer.style.height === "") {
				headerFormContainer.style.height = headerFormContainer.scrollHeight + "px";
			} else {
				headerFormContainer.style.height = "0px";
			}
		}
	</script>
</body>
</html>