<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
	<title>Billx - POS</title>

	<link rel="preconnect" href="https://fonts.googleapis.com">
	<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
	<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@200;300;400;500;600&display=swap" rel="stylesheet">
	<link href="https://fonts.googleapis.com/css2?family=Cairo:wght@400;500;600;700;800&display=swap" rel="stylesheet">
	<link href="assets/css/bootstrap.min.css" rel="stylesheet" />
	<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet" />
	<link href="assets/css/style.css" rel="stylesheet" />
	<link href="assets/css/media.css" rel="stylesheet" />
	<style type="text/css">
		body{
			overflow: hidden;
		}
	</style>
</head>
<body class="overflow-hidden">
	<!-- Header -->
	<header class="main-header bg-white z-1">
		<nav class="navbar navbar-expand-lg bg-transparent border-bottom">
			<div class="container-fluid px-3">
				<a class="navbar-brand m-0" href="#">
					<img class="" alt="Tblillx Logo" src="assets/images/logo.svg" />
				</a>
				<div class="ms-auto d-flex align-items-center">
					<div class="header-time-table ms-1 text-black px-3 py-2 rounded-pill d-none d-lg-flex">
						<small>10:53:00  26/02/2023</small>
					</div>
					<div class="btn-group">
						<div class="user-avatar-btn rounded-pill ms-2">
							<img src="assets/images/avatar-small.svg" alt="User Avatar" class="d-block">
						</div>
					</div>
				</div>
			</div>
		</nav>
	</header>
	<!-- ./Header -->
	<!-- Main Wrapper -->
	<div class="main-container pt-top h-100">
		<div class="d-flex align-items-center justify-content-center h-100">
			<div class="billxatndce-container py-3 record-attedence">
				<div class="billxatndce-logo text-center mb-5">
					<img class="" alt="Tblillx Logo" src="assets/images/logo.svg" />
					<div class="mt-2 mb-3">
						<p class="enter-login-pin m-0">Welcome Mohamed Ahmed</p>
						<div class="not-logged-in m-0">
							<p class="enter-login-pin m-0 attendance-recorded">Attendance has been recorded 18 /12/2023 01:12</p>
						</div>
					</div>
				</div>
				<form class="billxatndce-form billxrecord-form" action="">
					<div class="row g-3 ">
						<div class="m-0 p-0">
							<input type="radio" class="btn-check billx-btn-check" name="recordAttendance" id="recordAttendance" autocomplete="off" checked="">
							<label class="btn w-100" for="recordAttendance">Record attendance</label>
						</div>
						<div class="m-0 p-0">
							<input type="radio" class="btn-check billx-btn-check" name="recordAttendance" id="EntryToAccounting" autocomplete="off">
							<label class="btn w-100" for="EntryToAccounting">Entry to accounting</label>
						</div>

						<!-- <button type="button" class="btn billx-atndce-btn btn-with-shadow key-btn active" id="recordAttendanceBtn" value="">Record attendance</button>
						<button type="button" class="btn billx-atndce-btn btn-with-shadow key-btn" id="entryToAccountingBtn" value="">Entry to accounting</button> -->

						<button type="button" class="btn billx-submit-btn btn-with-shadow mt-4 mb-0 mx-0 p-3 h-auto rounded-12 w-100" id="" value="">Exit</button>
					</div>
				</form>
			</div>
		</div>
	</div>
	<!-- ./Main Wrapper -->
	
	<script src="assets/js/jquery.min.js"></script>
	<script src="assets/js/bootstrap.bundle.min.js"></script>
	<script type="text/javascript">
		$(document).ready(function () {
			// $('.billxrecord-form').on('click', '.key-btn', function() {
			//     $('.billxrecord-form .key-btn.active').removeClass('active');
			//     $(this).addClass('active');
			// });

			$(".key-btn").each(function () {
			    var clickedId = $(this).attr("id");
			    if ($(this).hasClass("active")) {
			        if (clickedId === "recordAttendanceBtn") {
			            $(".not-logged-in").html('<p class="enter-login-pin m-0 attendance-recorded">Attendance has been recorded 18/12/2023 01:12</p>');
			        } else if (clickedId === "entryToAccountingBtn") {
			            $(".not-logged-in").html('<a class="enter-login-pin m-0" href="#">Not logged in</a>');
			        }
			    } else {
			        $(".not-logged-in").html('<p class="enter-login-pin m-0 attendance-recorded">Attendance has been recorded 18/12/2023 01:12</p>');
			    }
			});

			$('.billxrecord-form').on('click', '.key-btn', function() {
			    $('.key-btn.active').removeClass('active');
			    $(this).addClass('active');

			    var clickedIdd = $(this).attr("id");
			    if ($(this).hasClass("active")) {
			        if (clickedIdd === "recordAttendanceBtn") {
			            $(".not-logged-in").html('<p class="enter-login-pin m-0 attendance-recorded">Attendance has been recorded 18 /12/2023 01:12</p>');
			        } else if (clickedIdd === "entryToAccountingBtn") {
			            $(".not-logged-in").html('<a class="enter-login-pin m-0" href="#">Not logged in</a>');
			        }
			    } else {
			        $(".not-logged-in").html('<p class="enter-login-pin m-0 attendance-recorded">Attendance has been recorded 18 /12/2023 01:12</p>');
			    }
			});

			var selectedId = $('input[name="recordAttendance"]:checked').attr("id");
			if (selectedId === "recordAttendance") {
		        $(".not-logged-in").html('<p class="enter-login-pin m-0 attendance-recorded">Attendance has been recorded 18 /12/2023 01:12</p>');
		    } else if (selectedId === "EntryToAccounting") {
		        $(".not-logged-in").html('<a class="enter-login-pin m-0" href="#">Not logged in</a>');
		    }
			$('input[type="radio"]').change(function () {
				var selectedId = $('input[name="recordAttendance"]:checked').attr("id");
			    if (selectedId === "recordAttendance") {
			        $(".not-logged-in").html('<p class="enter-login-pin m-0 attendance-recorded">Attendance has been recorded 18 /12/2023 01:12</p>');
			    } else if (selectedId === "EntryToAccounting") {
			        $(".not-logged-in").html('<a class="enter-login-pin m-0" href="#">Not logged in</a>');
			    }
			});

		});
	</script>
</body>
</html>