<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
	<title>Billx - POS</title>

	<link rel="preconnect" href="https://fonts.googleapis.com">
	<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
	<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@200;300;400;500;600&display=swap" rel="stylesheet">
	<link href="https://fonts.googleapis.com/css2?family=Cairo:wght@400;500;600;700;800&display=swap" rel="stylesheet">
	<link href="assets/css/bootstrap.min.css" rel="stylesheet" />
	<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet" />
	<link href="assets/css/style.css" rel="stylesheet" />
	<link href="assets/css/media.css" rel="stylesheet" />
	<style type="text/css">
		body{
			overflow: hidden;
		}
	</style>
</head>
<body class="overflow-hidden">
	<!-- Header -->
	<header class="main-header bg-white z-1">
		<nav class="navbar navbar-expand-lg bg-transparent border-bottom">
			<div class="container-fluid px-3">
				<a class="navbar-brand m-0" href="#">
					<img class="" alt="Tblillx Logo" src="assets/images/logo.svg" />
				</a>
				<div class="ms-auto d-flex align-items-center">
					<div class="header-time-table ms-1 text-black px-3 py-2 rounded-pill d-none d-lg-flex">
						<small>10:53:00  26/02/2023</small>
					</div>
					<div class="btn-group">
						<div class="user-avatar-btn rounded-pill ms-2">
							<img src="assets/images/avatar-small.svg" alt="User Avatar" class="d-block">
						</div>
					</div>
				</div>
			</div>
		</nav>
	</header>
	<!-- ./Header -->
	<!-- Main Wrapper -->
	<div class="main-container pt-top h-100">
		<div class="d-flex align-items-center justify-content-center h-100">
			<div class="billxatndce-container py-3">
				<div class="billxatndce-logo text-center">
					<img class="" alt="Tblillx Logo" src="assets/images/logo.svg" />
					<p class="enter-login-pin">Enter Your Login Pin</p>
				</div>
				<form class="billxatndce-form" action="">
					<div class="row g-3">
						<div class="col-12 mb-3 billxatndce-preview-field px-0">
							<input type="text" id="billxPIninputfield" class="form-control rounded-8 login-pin-input px-3" name="billxPIninputfield" value="" readonly="" />
						</div>
						<?php for ($x = 1; $x <= 9; $x++) { ?>
						<button type="button" class="btn btn-with-shadow billx-atndce-btn key-btn bg-white" id="keyBtnValue<?php echo $x ?>" value="<?php echo $x ?>"><?php echo $x ?></button>
						<?php } ?>
						<button type="button" class="btn btn-with-shadow billx-atndce-btn key-btn bg-white" id="keyBtnValue0" value="0">0</button>
						<button type="button" class="btn btn-with-shadow billx-atndce-btn key-btn bg-white key-btn-clear" id="keyBtnValueClear" value="clear">C</button>
						<button type="button" class="btn btn-primary btn-theme-primary login-syncusers-btn py-2 font-size-18 rounded-8" id="keyBtnValueClear" value="clear">Sync Users</button>
					</div>
				</form>
			</div>
		</div>
	</div>
	<!-- ./Main Wrapper -->
	
	<script src="assets/js/jquery.min.js"></script>
	<script src="assets/js/bootstrap.bundle.min.js"></script>
	<script type="text/javascript">
		$(document).ready(function () {
			$('#billxPIninputfield').on('input', function() {
		    	$(this).val($(this).val().replace(/[^0-9]/g, ''));
		    });

			var inputField = $("#billxPIninputfield");

			// Click event for number buttons
			$(".key-btn").on("click", function () {
			    inputField.val(inputField.val() + $(this).text());
			});

			// Click event for clear button
			$("#keyBtnValueClear").on("click", function () {
			    inputField.val("");
			});
		});
	</script>
</body>
</html>